
import { PrismaClient } from '@prisma/client';
import bcrypt from 'bcryptjs';

const prisma = new PrismaClient();

async function main() {
    const email = 'qa_auto_elite@test.com';
    const password = 'StrongP@ssw0rd123!';
    const hashedPassword = await bcrypt.hash(password, 12);

    try {
        const user = await prisma.user.upsert({
            where: { email },
            update: {},
            create: {
                email,
                passwordHash: hashedPassword,
                firstName: 'QA',
                lastName: 'Elite',
                subscriptionTier: 'ELITE',
                emailVerified: true,
                emailVerifiedAt: new Date(),
            },
        });
        console.log(`User ensured: ${user.email} with tier ${user.subscriptionTier}`);
    } catch (e) {
        console.error(e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
