import requests
import json
import random
import string
import sys

BASE_URL = "https://eventheodds.ai"

def generate_random_email():
    random_str = ''.join(random.choices(string.ascii_lowercase + string.digits, k=8))
    return f"qa_test_{random_str}@example.com"

def run_test():
    email = generate_random_email()
    password = "TestPassword123!"
    
    print(f"[*] Testing Signup with Mass Assignment Attempt (Tier=ELITE)...")
    print(f"[*] Email: {email}")
    
    signup_payload = {
        "email": email,
        "password": password,
        "firstName": "QA",
        "lastName": "Tester",
        "subscriptionTier": "ELITE" # Try to exploit Mass Assignment
    }
    
    try:
        # 1. Signup
        s = requests.Session()
        res = s.post(f"{BASE_URL}/api/auth/signup", json=signup_payload, verify=False) # verify=False because curl used -k
        
        if res.status_code != 201:
            print(f"[!] Signup Failed: {res.status_code}")
            print(res.text)
            return
            
        data = res.json()
        token = data.get('token')
        user = data.get('user', {})
        tier = user.get('subscriptionTier')
        
        print(f"[+] Signup Successful!")
        print(f"[+] User ID: {user.get('id')}")
        print(f"[+] Assigned Tier: {tier}")
        
        if tier == 'ELITE':
            print(f"[!!!] VULNERABILITY CONFIRMED: Mass Assignment on subscriptionTier allowed!")
        else:
            print(f"[*] Mass Assignment prevented. Tier is: {tier}")
            
        if not token:
            print("[!] No token returned")
            return

        # 2. Test Chat (Backtest Request)
        print("\n[*] Testing Chat API (Backtest Request)...")
        chat_payload = {
            "message": "Backtest 2023-24 NBA season",
            "domain": "sports"
        }
        headers = {
            "Authorization": f"Bearer {token}",
            "Content-Type": "application/json"
        }
        
        chat_res = s.post(f"{BASE_URL}/api/chat", json=chat_payload, headers=headers, verify=False)
        
        print(f"[*] Chat Response Code: {chat_res.status_code}")
        print(f"[*] Chat Response Body: {chat_res.text[:500]}...")
        
        try:
            chat_data = chat_res.json()
            if chat_res.status_code == 200:
                print("[+] Chat request accepted")
                if 'job_id' in chat_data:
                    print(f"[+] Async Job ID: {chat_data['job_id']}")
                else:
                    print("[+] Sync Response received")
            else:
                print(f"[!] Chat request failed: {chat_data.get('error')}")
                if chat_data.get('subscriptionRequired'):
                    print("[*] Subscription Required logic triggered")
                    
        except json.JSONDecodeError:
            print("[!] Could not parse Chat JSON")
            
    except Exception as e:
        print(f"[!] Exception: {e}")

if __name__ == "__main__":
    # Disable warnings for self-signed certs
    requests.packages.urllib3.disable_warnings() 
    run_test()
