import requests
import json
import random
import string
import subprocess
import time

BASE_URL = "http://108.181.196.146/backtest"
DB_PATH = "prisma/dev.db"

def generate_random_email():
    random_str = ''.join(random.choices(string.ascii_lowercase + string.digits, k=8))
    return f"qa_mixed_{random_str}@example.com"

def run_db_update(email):
    print(f"[*] Manually verifying email {email} in REMOTE DB via SSH...")
    # Escape quotes for shell
    query = f"UPDATE users SET emailVerified=1 WHERE email='{email}';"
    
    # SSH Command
    ssh_cmd = [
        'sshpass', '-p', 'Desertnaga908604$', # Password
        'ssh', '-o', 'StrictHostKeyChecking=no',
        'administrator@108.181.196.146',
        f'sqlite3 /var/www/html/eventheodds/prisma/dev.db "{query}"'
    ]
    
    try:
        subprocess.run(ssh_cmd, check=True)
        print("[+] Remote DB Update Successful")
    except subprocess.CalledProcessError as e:
        print(f"[!] Remote DB Update Failed: {e}")
    except Exception as e:
        print(f"[!] DB Update Exception: {e}")

def run_test():
    email = generate_random_email()
    password = "TestPassword123!"
    
    # 1. Signup (Trying Mass Assignment)
    print(f"\n--- Phase 1: Signup & vulnerabilities ---")
    signup_payload = {
        "email": email,
        "password": password,
        "firstName": "QA",
        "lastName": "Bot",
        "subscriptionTier": "ELITE" 
    }
    
    s = requests.Session()
    # disable SSL warnings
    requests.packages.urllib3.disable_warnings()
    
    try:
        res = s.post(f"{BASE_URL}/api/auth/signup", json=signup_payload, verify=False)
        if res.status_code != 201:
            print(f"[!] Signup Failed: {res.text}")
            return
            
        data = res.json()
        print(f"[+] Signup OK. Tier: {data['user'].get('subscriptionTier')}")
        if data['user'].get('subscriptionTier') == 'ELITE':
            print("[!!!] VULN CONFIRMED: Mass Assignment")
        else:
            print("[+] Mass Assignment Prevented (Tier is NOT ELITE)")
        
        # 2. Try Immediate Login (Testing Auto-Verify Fix)
        print(f"\n--- Phase 2: Login (Immediate) ---")
        login_payload = {"email": email, "password": password}
        res_login = s.post(f"{BASE_URL}/api/auth/login", json=login_payload, verify=False)
        
        if res_login.status_code == 200:
             print("[+] Immediate Login Successful! Auto-verify is WORKING.")
             token = res_login.json().get('token')
        else:
             print(f"[!] Immediate Login Failed ({res_login.status_code}). Auto-verify NOT working.")
             print(f"    Body: {res_login.text}")
             # Fallback to SSH verification
             run_db_update(email)
             print("[*] Retrying login after manual verification...")
             res_login = s.post(f"{BASE_URL}/api/auth/login", json=login_payload, verify=False)
             if res_login.status_code != 200:
                  print(f"[!] Login Failed even after manual fix: {res_login.text}")
                  return
             token = res_login.json().get('token')
             print(f"[+] Login OK after manual verify. Token obtained.")
        
        # 4. Chat Test
        print(f"\n--- Phase 3: Chat Backtest ---")
        chat_payload = {
            "message": "Backtest an NHL strategy during the 2023-2024 season: Bet on the Home Team to WIN if they did NOT play yesterday (rested) but the Away Team DID play yesterday (tired/back-to-back).",
            "domain": "sports"
        }
        headers = {
            "Authorization": f"Bearer {token}",
            "Content-Type": "application/json"
        }
        
        print("[*] Sending Chat Request (this triggers RAG + Grok)...")
        chat_res = s.post(f"{BASE_URL}/api/chat", json=chat_payload, headers=headers, verify=False)
        print(f"[*] Chat Status: {chat_res.status_code}")
        
        if chat_res.status_code == 200:
            print("[+] Chat Request SUCCEEDED!")
            chat_data = chat_res.json()
            if 'job_id' in chat_data:
                job_id = chat_data['job_id']
                print(f"[+] Job ID: {job_id}. Polling...")
                # Poll
                for _ in range(30):
                    time.sleep(2)
                    poll_res = s.get(f"{BASE_URL}/api/backtest/status/{job_id}", headers=headers, verify=False)
                    status = poll_res.json().get('status')
                    print(f"    Poll Status: {poll_res.status_code} - {status}")
                    if status == 'completed':
                        print("[+] Backtest COMPLETED Successfully!")
                        result_data = poll_res.json().get('results', {})
                        print(f"    Result Summary: {str(result_data)[:200]}...")
                        break
                    if status == 'failed':
                        print(f"[!] Backtest FAILED: {poll_res.json().get('error')}")
                        break
            else:
                print("[+] Sync Response (No Job ID):")
                print(chat_res.text[:500])
                
        elif chat_res.status_code == 403:
            print("[!] 403 Forbidden. Possible tier check fail.")
            print(chat_res.text)
        else:
            print(f"[!] Chat Request Failed: {chat_res.status_code}")
            print(chat_res.text)

    except Exception as e:
        print(f"[!] Error: {e}")

if __name__ == "__main__":
    run_test()
