#!/bin/bash

# Start QuantEdge AI Python Microservice

echo "🐍 Starting QuantEdge AI Python Microservice..."
echo "📍 Service URL: http://localhost:8000"
echo "📊 Health Check: http://localhost:8000/health"
echo ""

# Check if virtual environment exists
if [ ! -d "venv" ]; then
    echo "🔧 Creating virtual environment..."
    python3 -m venv venv
fi

# Activate virtual environment
echo "🔄 Activating virtual environment..."
source venv/bin/activate

# Install/update dependencies
echo "📦 Installing dependencies..."
pip install -r requirements.txt

# Start the service
echo "🚀 Starting FastAPI service..."
python main.py
