/**
 * @type {import("next").NextConfig}
 * 
 * ╔══════════════════════════════════════════════════════════════════════════════╗
 * ║  ⚠️  IMPORTANT: PRODUCTION CONFIGURATION - DO NOT MODIFY WITHOUT READING  ⚠️  ║
 * ╠══════════════════════════════════════════════════════════════════════════════╣
 * ║                                                                              ║
 * ║  This is the LIVE PRODUCTION config for eventheodds.ai                       ║
 * ║                                                                              ║
 * ║  DO NOT enable basePath for production!                                      ║
 * ║  - Apache proxies "/" → localhost:3000                                       ║
 * ║  - If basePath is set, the homepage will return 404                          ║
 * ║                                                                              ║
 * ║  Last issue: Dec 23, 2025 - basePath caused 404 on homepage                  ║
 * ║                                                                              ║
 * ╚══════════════════════════════════════════════════════════════════════════════╝
 */

const nextConfig = {
  // ┌─────────────────────────────────────────────────────────────────────────────┐
  // │ ⛔ basePath - KEEP COMMENTED OUT FOR PRODUCTION (eventheodds.ai)            │
  // │                                                                             │
  // │ Why: Apache config proxies "/" to localhost:3000 without any prefix.        │
  // │ If basePath is enabled, Next.js expects /backtest/* but Apache sends /*.    │
  // │ This causes a 404 error on the homepage and all pages.                      │
  // │                                                                             │
  // │ Only enable basePath if:                                                    │
  // │   1. You change Apache to proxy to /backtest                                │
  // │   2. You are running in a subdirectory setup (not dedicated domain)         │
  // └─────────────────────────────────────────────────────────────────────────────┘
  // basePath: "/backtest",  // ⛔ DO NOT UNCOMMENT FOR PRODUCTION

  // Next.js 15 specific optimizations
  serverExternalPackages: ["@prisma/client", "prisma"],

  // Image optimization
  images: {
    formats: ["image/avif", "image/webp"],
    remotePatterns: [
      {
        protocol: "https",
        hostname: "eventheodds.ai",
      },
      {
        protocol: "https",
        hostname: "eventheoddsai.com",
      },
      {
        protocol: "https",
        hostname: "*.eventheodds.ai",
      },
    ],
  },

  // Performance optimizations
  compiler: {
    removeConsole: false, // Disabled for debugging
  },

  // Environment variables available to the client
  env: {
    NEXT_PUBLIC_BASE_URL: process.env.NEXT_PUBLIC_BASE_URL || "https://eventheodds.ai",
    NEXT_PUBLIC_APP_NAME: "EvenTheOdds AI",
  },

  // Temporarily ignore TypeScript and ESLint errors during build
  // TODO: Fix all TypeScript errors and remove these flags
  typescript: {
    ignoreBuildErrors: true,
  },
  eslint: {
    ignoreDuringBuilds: true,
  },

  // Headers for security
  async headers() {
    return [
      {
        source: "/:path*",
        headers: [
          {
            key: "X-DNS-Prefetch-Control",
            value: "on",
          },
          {
            key: "X-Content-Type-Options",
            value: "nosniff",
          },
          {
            key: "X-Frame-Options",
            value: "DENY",
          },
          {
            key: "X-XSS-Protection",
            value: "1; mode=block",
          },
        ],
      },
    ];
  },
};

export default nextConfig;
