module.exports = {
    apps: [
        {
            name: 'eventheodds-web',
            script: 'npm',
            args: 'start',
            cwd: '/var/www/html/eventheodds',
            env_file: '/var/www/html/eventheodds/.env',
            env: {
                NODE_ENV: 'production',
                PORT: 3000
            },
            instances: 1,
            autorestart: true,
            watch: false,
            max_memory_restart: '1G',
        },
        {
            name: 'eventheodds-rag',
            script: './scripts/start-rag-service.sh',
            cwd: '/var/www/html/eventheodds',
            interpreter: '/bin/bash',
            env_file: '/var/www/html/eventheodds/.env',
            min_uptime: '5s',
            max_restarts: 10,
            autorestart: true,
        }
    ]
};
