import { test, expect } from '@playwright/test';

test('Dashboard loads without JavaScript errors', async ({ page }) => {
  // Listen for console errors
  const errors: string[] = [];
  page.on('console', msg => {
    if (msg.type() === 'error') {
      errors.push(msg.text());
    }
  });

  // Navigate to dashboard
  await page.goto('http://localhost:3003/dashboard');

  // Wait for page to load
  await page.waitForLoadState('networkidle');

  // Check that no critical JavaScript errors occurred
  const criticalErrors = errors.filter(error =>
    error.includes('finalContent is not defined') ||
    error.includes('index is not defined') ||
    error.includes('Cannot read property') ||
    error.includes('TypeError')
  );

  // Should have no critical JavaScript errors
  expect(criticalErrors.length).toBe(0);

  // Check that dashboard content is visible
  await expect(page.locator('text=AI Strategy Assistant')).toBeVisible();

  // Check that tabs are present
  await expect(page.locator('text=AI Chat')).toBeVisible();
  await expect(page.locator('text=Updates')).toBeVisible();
  await expect(page.locator('text=Feedback')).toBeVisible();
});
