# LeadGen Backtesting Studio · TODO

Use this backlog to coordinate effort across ingestion, modeling, UI, and
infrastructure. Items are grouped by theme and roughly ordered.

## Data & Storage

- [ ] Wire nightly ingestion jobs for the production sports/crypto/stocks CSVs
- [ ] Add schema validation + drift alerts for every CSV feed
- [ ] Normalize odds formats (American, decimal, implied probability)
- [ ] Append advanced sports metrics (pace, possessions, drive distance)
- [ ] Capture crypto order-book imbalance + funding rate snapshots
- [ ] Expand stock dataset with factor exposures (value, momentum, quality)
- [ ] Create versioned dataset manifests w/ hashes for reproducibility
- [ ] Add parquet exports + DuckDB views for heavier simulations
- [ ] Build a synthetic benchmark dataset for CI pipelines

## APIs & Integrations

- [ ] Replace demo CoinGecko call with premium multi-asset feed
- [ ] Add sportsbook odds API + webhooks when markets open
- [ ] Integrate macro calendar + news sentiment providers
- [ ] Stand up WebSocket listener for high-frequency crypto prices
- [ ] Cache API responses with Redis / Upstash
- [ ] Add failure budgets + retries for each upstream provider
- [ ] Build secrets loader for API keys (Vault or Doppler)

## RAG & Intelligence Layer

- [ ] Connect to actual vector store (Pinecone, Weaviate, pgvector, etc.)
- [ ] Implement embedding refresh schedule + drift monitoring
- [ ] Support citations w/ page numbers + confidence scoring
- [ ] Add user preference profiles (favorite leagues, tickers)
- [ ] Teach the parser to remember previously approved strategies
- [ ] Layer guardrails to avoid duplicate or contradictory insights

## Strategy Engine

- [ ] Expand parser to support bankroll management and Kelly sizing
- [ ] Add scenario slicing (home/away, regime filters, volatility buckets)
- [ ] Implement Monte Carlo shuffles + walk-forward validation
- [ ] Allow chaining rules (e.g., loss streak AND injury report)
- [ ] Surface risk metrics (max DD, Sharpe, ulcer index)
- [ ] Export trades to CSV / Excel
- [ ] Add GPU-accelerated path for massive strategy sweeps

## Product & UI

- [ ] Multi-user auth + workspace selector
- [ ] Conversational history panel with per-message diffs
- [ ] Visualization suite: equity curves, drawdown charts, heatmaps
- [ ] Strategy library with versioning + comments
- [ ] Upload center for drag/drop CSVs and RAG documents
- [ ] Notifications (email/Slack) when backtests finish
- [ ] Mobile layout polish + dark/light mode toggle

## Infrastructure & Ops

- [ ] Containerize app for Fly.io / AWS ECS
- [ ] CI pipeline (lint, test, typecheck, e2e smoke)
- [ ] Observability stack (OpenTelemetry traces, structured logs)
- [ ] Feature flag system for staged rollouts
- [ ] Disaster recovery plan for RAG + dataset storage
- [ ] Compliance review for storing betting & financial logs

