#!/bin/bash

# Configuration
REMOTE_USER="administrator"
REMOTE_HOST="108.181.196.146"
REMOTE_DIR="/var/www/html/eventheodds"
SSH_PASS='Desertnaga908604$'

# Colors
GREEN='\033[0;32m'
NC='\033[0m' # No Color

echo -e "${GREEN}Starting deployment to $REMOTE_HOST...${NC}"

# Check if sshpass is installed
if ! command -v sshpass &> /dev/null; then
    echo "sshpass is not installed. Installing it..."
    if command -v apt-get &> /dev/null; then
        sudo apt-get update && sudo apt-get install -y sshpass
    else
        echo "Please install sshpass manually."
        exit 1
    fi
fi

# 1. Prepare Remote Server (System Deps & Directory Permissions)
echo -e "${GREEN}Preparing remote server...${NC}"
# We construct a single command string to be executed on the remote server
# We use sudo -S to accept password from stdin
PREPARE_CMDS="
echo '$SSH_PASS' | sudo -S -k apt-get update
echo '$SSH_PASS' | sudo -S -k apt-get install -y curl git unzip python3-full python3-pip python3-venv nginx rsync

# Install Node.js (v20)
if ! command -v node &> /dev/null; then
    curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -S bash -
    echo '$SSH_PASS' | sudo -S -k apt-get install -y nodejs
fi

# Install PM2
if ! command -v pm2 &> /dev/null; then
    echo '$SSH_PASS' | sudo -S -k npm install -g pm2
fi

# Create Directory and Fix Permissions
echo '$SSH_PASS' | sudo -S -k mkdir -p $REMOTE_DIR
echo '$SSH_PASS' | sudo -S -k chown -R $REMOTE_USER:$REMOTE_USER $REMOTE_DIR
"

sshpass -p "$SSH_PASS" ssh -o StrictHostKeyChecking=no $REMOTE_USER@$REMOTE_HOST "$PREPARE_CMDS"

# 2. Transfer Files
echo -e "${GREEN}Transferring files...${NC}"
sshpass -p "$SSH_PASS" rsync -avz --exclude 'node_modules' \
    --exclude '.next' \
    --exclude '.git' \
    --exclude 'rag_env' \
    --exclude '__pycache__' \
    --exclude '.env' \
    ./ $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR

sshpass -p "$SSH_PASS" scp .env $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/.env

# 3. Remote Configuration & Build
echo -e "${GREEN}Configuring and building on remote...${NC}"
CONFIG_CMDS="
    cd $REMOTE_DIR

    # Install Node Dependencies
    echo 'Installing Node dependencies...'
    npm install

    # Install Python RAG Dependencies
    echo 'Setting up Python RAG environment...'
    cd airagagent
    if [ ! -d 'rag_env' ]; then
        python3 -m venv rag_env
    fi
    source rag_env/bin/activate
    if [ -f 'requirements.txt' ]; then
        pip install -r requirements.txt
    fi
    cd ..

    # Build Next.js App
    echo 'Building Next.js app...'
    npm run build

    # Config Apache
    echo 'Configuring Apache...'
    echo '$SSH_PASS' | sudo -S -k systemctl stop nginx || true
    echo '$SSH_PASS' | sudo -S -k systemctl disable nginx || true

    echo 'Enabling Proxy Modules...'
    echo '$SSH_PASS' | sudo -S -k a2enmod proxy proxy_http

    if [ -f "apache.conf" ]; then
        echo 'Applying Apache Config...'
        echo '$SSH_PASS' | sudo -S -k cp apache.conf /etc/apache2/sites-available/000-default.conf
    fi

    if [ -f "contentcreator-ip.conf" ]; then
        echo 'Applying ContentCreator IP Config...'
        echo '$SSH_PASS' | sudo -S -k cp contentcreator-ip.conf /etc/apache2/sites-available/100-contentcreator-ip.conf
        # Ensure it is enabled as a symlink
        echo '$SSH_PASS' | sudo -S -k rm -f /etc/apache2/sites-enabled/100-contentcreator-ip.conf
        echo '$SSH_PASS' | sudo -S -k ln -s /etc/apache2/sites-available/100-contentcreator-ip.conf /etc/apache2/sites-enabled/100-contentcreator-ip.conf
    fi

    echo 'Reloading Apache...'
    echo '$SSH_PASS' | sudo -S -k systemctl reload apache2

    # Start with PM2
    echo 'Starting with PM2...'
    pm2 delete eventheodds-web || true
    pm2 delete eventheodds-rag || true
    pm2 delete backtest-web || true
    pm2 delete backtest-rag || true
    
    pm2 start ecosystem.config.js
    pm2 save
"

sshpass -p "$SSH_PASS" ssh $REMOTE_USER@$REMOTE_HOST "$CONFIG_CMDS"

echo -e "${GREEN}Deployment Complete!${NC}"
echo -e "Visit: http://$REMOTE_HOST/backtest"
