const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

async function createSystemUser() {
  try {
    // Check if system user exists
    let user = await prisma.user.findFirst({ where: { email: 'system@eventheodds.ai' }});
    if (!user) {
      user = await prisma.user.create({
        data: {
          id: 'system',
          email: 'system@eventheodds.ai',
          passwordHash: 'SYSTEM_USER_NO_LOGIN',
          firstName: 'System',
          lastName: 'User',
          subscriptionTier: 'FREE',
          role: 'USER',
          emailVerified: true,
        }
      });
      console.log('System user created:', user.id);
    } else {
      console.log('System user exists:', user.id);
    }
  } catch(e) { 
    console.error('Error:', e.message); 
  }
  await prisma.$disconnect();
}
createSystemUser();
