#!/bin/bash
# Batch convert all tick data CSV files to OHLC format
# This script will convert all CSV files in data/csv/ that aren't already OHLC files

echo "🔄 Starting batch conversion of all tick data CSV files..."
echo "📁 Looking in: data/csv/"
echo ""

# Check if we're in the right directory
if [ ! -d "data/csv" ]; then
    echo "❌ Error: data/csv/ directory not found. Please run from the project root."
    exit 1
fi

# Count CSV files
csv_count=$(find data/csv/ -name "*.csv" -not -name "*_ohlc.csv" | wc -l)

if [ "$csv_count" -eq 0 ]; then
    echo "✅ No new CSV files to convert. All files are already converted or none exist."
    echo ""
    echo "📁 Current OHLC files:"
    find data/csv/ -name "*_ohlc.csv" -exec basename {} \; | while read file; do
        echo "  • $file"
    done
    exit 0
fi

echo "📊 Found $csv_count CSV file(s) to convert:"
find data/csv/ -name "*.csv" -not -name "*_ohlc.csv" -exec basename {} \; | while read file; do
    echo "  • $file"
done
echo ""

# Run the conversion
python tick_data_converter.py --batch

echo ""
echo "🎯 Batch conversion completed!"
echo ""
echo "💡 Usage tips:"
echo "  • Single file: python tick_data_converter.py data/csv/YOURFILE.csv --timeframe 1hour"
echo "  • Batch all: ./convert_all_csv.sh or npm run convert:batch"
echo "  • Custom timeframe: python tick_data_converter.py data/csv/YOURFILE.csv --timeframe 5min"
