#!/usr/bin/env python3
"""
Test upload functionality directly
"""

import sys
import os

# Add the current directory to Python path
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from main import RAGSystem
from pathlib import Path

def test_upload_processing():
    """Test the upload processing directly"""
    print("Testing upload processing...")

    # Initialize RAG system
    rag_system = RAGSystem()

    # Manually add the PDF file to the directory (it should already be there)
    pdf_file = Path("/home/dmtnaga/Documents/work/airagagent/pdf_directory/H._P._Blavatsky_-_The_Secret_Doctrine.pdf")

    if not pdf_file.exists():
        print(f"PDF file not found: {pdf_file}")
        return

    print(f"PDF file exists: {pdf_file}")
    print(f"File size: {pdf_file.stat().st_size} bytes")

    try:
        # Try to process the system
        print("Calling setup_system()...")
        doc_count = rag_system.setup_system()
        print(f"Setup complete. Total documents: {doc_count}")

        # Check status
        from config import PDF_DIR
        pdf_files = list(PDF_DIR.glob("*.pdf"))
        txt_files = list(PDF_DIR.glob("*.txt"))
        print(f"PDF files found: {len(pdf_files)}")
        print(f"TXT files found: {len(txt_files)}")
        print(f"Total files: {len(pdf_files) + len(txt_files)}")

    except Exception as e:
        import traceback
        print(f"Error during processing: {e}")
        print(f"Full traceback: {traceback.format_exc()}")

if __name__ == "__main__":
    test_upload_processing()
