#!/usr/bin/env python3
"""
Simple startup script for RAG service that fixes import issues
"""
import sys
import os

# Add parent directory to Python path so we can import airagagent
parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, parent_dir)

# Import and run the app
from airagagent.app import app

if __name__ == '__main__':
    print("🚀 Starting RAG Service on http://localhost:5000")
    app.run(host='0.0.0.0', port=5000, debug=False)
