# Mistral RAG System

A complete Retrieval-Augmented Generation (RAG) system with a web interface, powered by CPU-optimized language models.

## Features

- **Document Processing**: Supports PDF and text files with intelligent chunking
- **Vector Search**: FAISS-powered semantic search with sentence transformers
- **Language Model**: CPU-optimized GPT-2 model for question answering
- **Web Interface**: Modern Flask-based UI for document upload and Q&A
- **Incremental Processing**: Only processes new or modified documents

## Quick Start

1. **Activate the environment:**
   ```bash
   cd /home/dmtnaga/Documents/work/airagagent
   source rag_env/bin/activate
   ```

2. **Start the web interface:**
   ```bash
   python app.py
   ```

3. **Open your browser:**
   Visit `http://localhost:5000` to access the web interface.

## Project Structure

```
rag_system/
├── pdf_directory/          # Place your PDF/text files here
├── processed/
│   ├── embeddings/        # FAISS vector database
│   ├── documents/         # Processed document chunks
│   └── metadata/          # Processing history
├── templates/             # Flask HTML templates
├── static/               # Static web assets
├── config.py             # Configuration settings
├── pdf_processor.py      # Document processing logic
├── vector_store.py       # Vector database operations
├── mistral_integration.py # Language model integration
├── app.py               # Flask web application
├── main.py              # Command-line interface
└── test_system.py       # System testing utilities
```

## API Endpoints

- `GET /` - Web interface
- `POST /upload` - Upload documents
- `POST /ask` - Ask questions
- `GET /status` - System status

## Usage Examples

### Upload Documents
```bash
curl -X POST -F "file=@document.pdf" http://localhost:5000/upload
```

### Ask Questions
```bash
curl -X POST -H "Content-Type: application/json" \
     -d '{"question":"What is artificial intelligence?"}' \
     http://localhost:5000/ask
```

### Check Status
```bash
curl http://localhost:5000/status
```

## System Requirements

- Python 3.13+
- 4GB+ RAM (for model loading)
- Internet connection (for initial model download)

## Model Information

- **Embedding Model**: sentence-transformers/all-MiniLM-L6-v2
- **Language Model**: distilgpt2 (CPU-optimized)
- **Vector Database**: FAISS with cosine similarity

## Performance Notes

- First question may take 10-15 seconds (model loading)
- Subsequent questions are faster (~2-3 seconds)
- System runs entirely on CPU (no GPU required)
- Document processing is incremental (only new files are processed)

## Adding Documents

1. Place PDF or text files in the `pdf_directory/` folder
2. The system will automatically detect and process new files
3. Use the web interface or API to upload files directly

## Troubleshooting

- **Slow startup**: Model loading takes time on first use
- **Out of memory**: Reduce chunk size in config.py or use smaller model
- **No answers**: Check that documents are properly processed via /status endpoint

## Development

To modify the system:

1. Edit configuration in `config.py`
2. Update processing logic in respective modules
3. Test changes with `python test_system.py`
4. Restart the Flask app for web interface changes

## License

This project demonstrates RAG system implementation for educational purposes.
