## LeadGen Backtesting Studio

A conversational research surface where betting, crypto, and equity strategies
can be described in plain English and stress-tested instantly. Natural-language
prompts are parsed into rules, evaluated against CSV baselines, enriched with
live APIs, and explained with your Retrieval-Augmented (RAG) corpus.

### Stack

- Next.js App Router (TypeScript + Tailwind)
- API routes for simulations (`/api/strategies`)
- CSV loaders (`data/csv`) for reproducible datasets
- Optional RAG manifest in `rag/insights.json`
- Vitest for unit tests on the strategy engine

### Project structure

```
data/csv/                 Sample sports, crypto, and stock histories
rag/                      Drop your embeddings / manifests here
src/lib/csvLoader.ts      CSV ingestion helpers
src/lib/strategyEngine.ts Prompt parsing + simulations
src/app/api/strategies    API entry point (GET overview, POST simulate)
src/components/           UI widgets (StrategyPlayground, etc.)
```

### Getting started

```bash
# 1. Install dependencies
npm install

# 2. Set up database (see docs/DATABASE_SETUP.md for detailed instructions)
# Create .env file with DATABASE_URL
npm run db:setup

# 3. Start the application
npm run dev
# visit http://localhost:3000

# Optional: Start with RAG service
npm run dev:full
```

#### Database Setup
The application uses MySQL with Prisma ORM. See [Database Setup Guide](docs/DATABASE_SETUP.md) for complete instructions.

#### Stripe Setup (Required for Payments)
1. Create a [Stripe account](https://stripe.com)
2. Create products and prices in your Stripe dashboard:
   - **Free Trial**: $20/month with 7-day trial period
   - **Pro**: $20/month
   - **Elite**: $200/month
3. Get your API keys from the Stripe dashboard

Required environment variables:
- `DATABASE_URL` - MySQL connection string
- `JWT_SECRET` - For authentication tokens
- `GROK_API_KEY` - For AI strategy generation
- `STRIPE_PUBLISHABLE_KEY` - Stripe publishable key
- `STRIPE_SECRET_KEY` - Stripe secret key
- `STRIPE_WEBHOOK_SECRET` - Webhook endpoint secret
- `STRIPE_FREE_PRICE_ID` - Price ID for free trial plan
- `STRIPE_PRO_PRICE_ID` - Price ID for Pro plan
- `STRIPE_ELITE_PRICE_ID` - Price ID for Elite plan

Copy `.env.example` to `.env` and configure your values.

### Testing

```bash
npm run test        # unit tests (Vitest)
npm run coverage    # coverage summary
```

### RAG Integration

The system supports two RAG implementations:

#### 1. Simple JSON Manifest (Default)
`src/lib/ragGateway.ts` reads from `rag/insights.json`. Add trading insights here for basic RAG functionality.

#### 2. Full RAG Service (Recommended)
The chat interface integrates with a Flask-based RAG service (`airagagent/`) that provides:
- PDF document ingestion and chunking
- Vector embeddings with FAISS
- Semantic search with relevance scoring
- Citation tracking with source documents

**To enable full RAG:**
```bash
# Terminal 1: Start RAG service
npm run rag:start

# Terminal 2: Start Next.js app
npm run dev

# Or run both together:
npm run dev:full
```

**Add trading/betting books:**
1. Place PDF files in `airagagent/pdf_directory/`
2. The service will automatically process and index them
3. Chat responses will include relevant excerpts from your trading literature

**RAG Service API:**
- `POST /ask` - Search and answer questions
- `GET /status` - Service health check
- Runs on `http://localhost:5000` by default

### API usage

- `GET /api/strategies` &rarr; dataset metadata + live crypto snapshot
- `POST /api/strategies` with `{ prompt: string, domain: "sports"|"crypto"|"stocks" }`
  returns win rate, trades, rag insight, and (for crypto) live prices.

### Roadmap

A high-level backlog lives in `docs/todo.md`. Use it to track ingestion tasks,
evaluation upgrades, UI polish, and deployment work.
